capture log close

cd "U:\Hemmeter\SBST"
set more off
set logtype text
set seed 1234567890


log using "SSI Letters Results Month 24 $S_DATE", replace
use outcomes06062022, clear
compress

label define treatment 0 "Control" 1 "Basic" 2 "Maximum" 3 "Simplify" 4 "Combined", replace
label values treatment treatment
label define age_group 0 "65" 1 "66 to 70" 2 "71 to 75" 3 "76 to 80", replace
label values age_group age_group

gen former_ssi=(prior_ssi_status==2)
drop if treatment==.

	
	/*Balance Check*/
capture mat drop pval_0
	
foreach x of varlist age potentialssi zip_nw {
	ttest `x', by(anyletter)
	mat pval_0=(nullmat(pval_0)\r(p))
}
foreach x of varlist male prior wepgpo bica anyearn1-anyearn5 anyearn_last2 anyearn_last5 earn_inelig inelig former_ssi before_fra {
	prtest `x', by(anyletter)
	mat pval_0=(nullmat(pval_0)\r(p))
}
foreach x of varlist age_group potentialquint state_group state bentype2 /*earnben_inelig_* */ {
	tab `x' anyletter, chi
	mat pval_0=(nullmat(pval_0)\r(p))
}

forvalues i=1(1)4 {

	capture mat drop pval_`i'

	foreach x of varlist age potentialssi zip_nw {
		ttest `x' if inlist(treatment,0,`i'), by(treatment)
		mat pval_`i'=(nullmat(pval_`i')\r(p))
	}
	foreach x of varlist male prior wepgpo bica anyearn1-anyearn5 anyearn_last2 anyearn_last5 earn_inelig inelig former_ssi before_fra {
		prtest `x' if inlist(treatment,0,`i'), by(treatment)
		mat pval_`i'=(nullmat(pval_`i')\r(p))
	}
	foreach x of varlist age_group potentialquint state_group state bentype2 /*earnben_inelig_* */ {
		tab `x' treatment if inlist(treatment,0,`i'), chi col
		mat pval_`i'=(nullmat(pval_`i')\r(p))
	}		
}
mat p=(pval_0,pval_1,pval_2,pval_3,pval_4)
mat list p	
	
	*/
	/*outcomes*/
	
			
			/*
	/*Raw Outcomes*/

forvalues m=3(3)24 {
	
	capture mat drop raw1
	capture mat drop raw2
		
	foreach x of varlist applied`m' awarded`m' anyssi`m' {
		prtest `x', by(anyletter)
		mat raw1=(nullmat(raw1)\r(N1),r(P1),r(se1),r(N2),r(P2),r(se2),r(p))
	}
	foreach x of varlist avessi`m' totssimiss`m' numssimiss`m' totssi`m' numssi`m' {
		ttest `x', by(anyletter)
		mat se1=r(sd_1)/sqrt(r(N_1))
		mat se2=r(sd_2)/sqrt(r(N_2))	
		mat raw1=(nullmat(raw1)\r(N_1),r(mu_1),se1,r(N_2),r(mu_2),se2,r(p))
	}
	mat list raw1

	forvalues i=1(1)4 {
		capture mat drop raw_`i'
		foreach x of varlist applied`m' awarded`m' anyssi`m' {
			prtest `x' if inlist(treatment,0,`i'), by(treatment)
			mat raw_`i'=(nullmat(raw_`i')\r(N1),r(P1),r(se1),r(N2),r(P2),r(se2),r(p))
		}
		foreach x of varlist avessi`m' totssimiss`m' numssimiss`m' totssi`m' numssi`m' {
			ttest `x' if inlist(treatment,0,`i'), by(treatment)
			mat se1=r(sd_1)/sqrt(r(N_1))
			mat se2=r(sd_2)/sqrt(r(N_2))	
			mat raw_`i'=(nullmat(raw_`i')\r(N_1),r(mu_1),se1,r(N_2),r(mu_2),se2,r(p))
		}
	}
	mat raw2=(raw_1\raw_2\raw_3\raw_4)
	mat list raw2	
	mat raw=(raw1\raw2)
	mat list raw		

}

	*/
	

/*Tables 1 and 2*/

capture erase table1_2.xml
capture erase table1_2.txt

	foreach y of varlist applied24 awarded24 avessi24 anyssi24 totssi24 denycond24 {
	
		/*Statements--Letter Elements*/
		reg `y' anyletter i.maxbenefit##i.simplifying, cluster(state)
		outreg2 using table1_2, ctitle(`y'-statement) bdec(4) sdec(4) cdec(4) excel wide

	}

/*Tables 3 and 4*/

capture erase table3_4.xml
capture erase table3_4.txt

	foreach y of varlist applied24 awarded24 avessi24 {

		/*Age--Any letter only*/
		reg `y' ib0.anyletter##ib0.age_group, cluster(state)
		outreg2 using table3_4, ctitle(`y'-Age) bdec(4) sdec(4) cdec(4) excel wide
		
		/*Potential SSI Amount--Any letter only*/
		reg `y' ib0.anyletter##c.potentialssi, cluster(state)
		outreg2 using table3_4, ctitle(`y'-SSI) bdec(4) sdec(4) cdec(4) excel wide

		
	}	
	
/*Figure 1*/


graph bar (mean) applied24, over(anyletter)
graph bar (mean) applied24, over(treatment)

graph bar (mean) awarded24, over(anyletter)
graph bar (mean) awarded24, over(treatment)

mean applied24 awarded24 if anyletter==1
	mat app24estt=el(r(table),1,1)
	mat app24cilt=el(r(table),5,1)
	mat app24ciht=el(r(table),6,1)
	
	mat awd24estt=el(r(table),1,2)
	mat awd24cilt=el(r(table),5,2)
	mat awd24ciht=el(r(table),6,2)
		
mean applied24 awarded24, over(treatment)
	mat app24estc=el(r(table),1,1)
	mat app24cilc=el(r(table),5,1)
	mat app24cihc=el(r(table),6,1)
	
	mat app24estbas=el(r(table),1,2)
	mat app24cilbas=el(r(table),5,2)
	mat app24cihbas=el(r(table),6,2)

	mat app24estmax=el(r(table),1,3)
	mat app24cilmax=el(r(table),5,3)
	mat app24cihmax=el(r(table),6,3)

	mat app24estsimp=el(r(table),1,4)
	mat app24cilsimp=el(r(table),5,4)
	mat app24cihsimp=el(r(table),6,4)
	
	mat app24estcomb=el(r(table),1,5)
	mat app24cilcomb=el(r(table),5,5)
	mat app24cihcomb=el(r(table),6,5)
	
	mat awd24estc=el(r(table),1,6)
	mat awd24cilc=el(r(table),5,6)
	mat awd24cihc=el(r(table),6,6)
	
	mat awd24estbas=el(r(table),1,7)
	mat awd24cilbas=el(r(table),5,7)
	mat awd24cihbas=el(r(table),6,7)

	mat awd24estmax=el(r(table),1,8)
	mat awd24cilmax=el(r(table),5,8)
	mat awd24cihmax=el(r(table),6,8)

	mat awd24estsimp=el(r(table),1,9)
	mat awd24cilsimp=el(r(table),5,9)
	mat awd24cihsimp=el(r(table),6,9)
	
	mat awd24estcomb=el(r(table),1,10)
	mat awd24cilcomb=el(r(table),5,10)
	mat awd24cihcomb=el(r(table),6,10)
	
	mat est=(app24estc, awd24estc, app24estt, awd24estt, app24estbas, awd24estbas, app24estmax, awd24estmax, app24estsimp, awd24estsimp, app24estcomb, awd24estcomb)
	mat ci_low=(app24cilc, awd24cilc, app24cilt, awd24cilt, app24cilbas, awd24cilbas, app24cilmax, awd24cilmax, app24cilsimp, awd24cilsimp, app24cilcomb, awd24cilcomb)
	mat ci_hi=(app24cihc, awd24cihc, app24ciht, awd24ciht, app24cihbas, awd24cihbas, app24cihmax, awd24cihmax, app24cihsimp, awd24cihsimp, app24cihcomb, awd24cihcomb)
	
	
			mat coef_fig1= (est \ ci_low \ ci_hi)
			
			mat rownames coef_fig1= Estimate Low High 
			mat colnames coef_fig1= "No Letter-Application" "No Letter-Award" "Any Letter-Application" "Any Letter-Award" "Basic Letter-Application" "Basic Letter-Award" "Maximum Letter-Application" "Maximum Letter-Award" "Simple Letter-Application" "Simple Letter-Award" "Combined Letter-Application" "Combined Letter-Award"
			mat list coef_fig1
			mat coef_fig1p=coef_fig1'

matsave coef_fig1p, replace saving

					
						
			

/*Figure 2*/

graph bar (mean) avessi24, over(anyletter)
graph bar (mean) avessi24, over(treatment)

mean avessi24 if anyletter==1
	mat ave24estt=el(r(table),1,1)
	mat ave24cilt=el(r(table),5,1)
	mat ave24ciht=el(r(table),6,1)

mean avessi24, over(treatment)
	mat ave24estc=el(r(table),1,1)
	mat ave24cilc=el(r(table),5,1)
	mat ave24cihc=el(r(table),6,1)
	
	mat ave24estbas=el(r(table),1,2)
	mat ave24cilbas=el(r(table),5,2)
	mat ave24cihbas=el(r(table),6,2)

	mat ave24estmax=el(r(table),1,3)
	mat ave24cilmax=el(r(table),5,3)
	mat ave24cihmax=el(r(table),6,3)

	mat ave24estsimp=el(r(table),1,4)
	mat ave24cilsimp=el(r(table),5,4)
	mat ave24cihsimp=el(r(table),6,4)
	
	mat ave24estcomb=el(r(table),1,5)
	mat ave24cilcomb=el(r(table),5,5)
	mat ave24cihcomb=el(r(table),6,5)

	mat est=(ave24estc, ave24estt,  ave24estbas, ave24estmax, ave24estsimp, ave24estcomb)
	mat ci_low=(ave24cilc, ave24cilt, ave24cilbas, ave24cilmax, ave24cilsimp, ave24cilcomb)
	mat ci_hi=(ave24cihc, ave24ciht, ave24cihbas, ave24cihmax, ave24cihsimp, ave24cihcomb)
	
	
			mat coef_fig2= (est \ ci_low \ ci_hi)
			
			mat rownames coef_fig2= Estimate Low High 
			mat colnames coef_fig2= "Control" "Any" "Basic" "Maximum" "Simple" "Combined" 
			mat list coef_fig2
			mat coef_fig2p=coef_fig2'


matsave coef_fig2p, replace saving





/*Figure 3*/

graph bar (mean) applied3 (mean) applied6 (mean) applied9 (mean) applied12 (mean) applied15 (mean) applied18 (mean) applied21 (mean) applied24 if anyletter==1, over(anyletter)
graph bar (mean) awarded3 (mean) awarded6 (mean) awarded9 (mean) awarded12 (mean) awarded15 (mean) awarded18 (mean) awarded21 (mean) awarded24 if anyletter==1, over(anyletter)


mean applied3 applied6 applied9 applied12 applied15 applied18 applied21 applied24 if treatment==1
	mat app3estt=el(r(table),1,1)
	mat app3cilt=el(r(table),5,1)
	mat app3ciht=el(r(table),6,1)
	
	mat app6estt=el(r(table),1,2)
	mat app6cilt=el(r(table),5,2)
	mat app6ciht=el(r(table),6,2)
	
	mat app9estt=el(r(table),1,3)
	mat app9cilt=el(r(table),5,3)
	mat app9ciht=el(r(table),6,3)
	
	mat app12estt=el(r(table),1,4)
	mat app12cilt=el(r(table),5,4)
	mat app12ciht=el(r(table),6,4)
	
	mat app15estt=el(r(table),1,5)
	mat app15cilt=el(r(table),5,5)
	mat app15ciht=el(r(table),6,5)
	
	mat app18estt=el(r(table),1,6)
	mat app18cilt=el(r(table),5,6)
	mat app18ciht=el(r(table),6,6)
	
	mat app21estt=el(r(table),1,7)
	mat app21cilt=el(r(table),5,7)
	mat app21ciht=el(r(table),6,7)
		
	mat app24estt=el(r(table),1,8)
	mat app24cilt=el(r(table),5,8)
	mat app24ciht=el(r(table),6,8)

mean applied3 applied6 applied9 applied12 applied15 applied18 applied21 applied24, over(treatment)
	mat app3estc=el(r(table),1,1)
	mat app3cilc=el(r(table),5,1)
	mat app3cihc=el(r(table),6,1)
	
	mat app3estbas=el(r(table),1,2)
	mat app3cilbas=el(r(table),5,2)
	mat app3cihbas=el(r(table),6,2)
	
	mat app3estmax=el(r(table),1,3)
	mat app3cilmax=el(r(table),5,3)
	mat app3cihmax=el(r(table),6,3)
	
	mat app3estsimp=el(r(table),1,4)
	mat app3cilsimp=el(r(table),5,4)
	mat app3cihsimp=el(r(table),6,4)
	
	mat app3estcomb=el(r(table),1,5)
	mat app3cilcomb=el(r(table),5,5)
	mat app3cihcomb=el(r(table),6,5)
	
	mat app6estc=el(r(table),1,6)
	mat app6cilc=el(r(table),5,6)
	mat app6cihc=el(r(table),6,6)
	
	mat app6estbas=el(r(table),1,7)
	mat app6cilbas=el(r(table),5,7)
	mat app6cihbas=el(r(table),6,7)
	
	mat app6estmax=el(r(table),1,8)
	mat app6cilmax=el(r(table),5,8)
	mat app6cihmax=el(r(table),6,8)
	
	mat app6estsimp=el(r(table),1,9)
	mat app6cilsimp=el(r(table),5,9)
	mat app6cihsimp=el(r(table),6,9)
	
	mat app6estcomb=el(r(table),1,10)
	mat app6cilcomb=el(r(table),5,10)
	mat app6cihcomb=el(r(table),6,10)
	
	mat app9estc=el(r(table),1,11)
	mat app9cilc=el(r(table),5,11)
	mat app9cihc=el(r(table),6,11)
	
	mat app9estbas=el(r(table),1,12)
	mat app9cilbas=el(r(table),5,12)
	mat app9cihbas=el(r(table),6,12)
	
	mat app9estmax=el(r(table),1,13)
	mat app9cilmax=el(r(table),5,13)
	mat app9cihmax=el(r(table),6,13)
	
	mat app9estsimp=el(r(table),1,14)
	mat app9cilsimp=el(r(table),5,14)
	mat app9cihsimp=el(r(table),6,14)
	
	mat app9estcomb=el(r(table),1,15)
	mat app9cilcomb=el(r(table),5,15)
	mat app9cihcomb=el(r(table),6,15)
	
	mat app12estc=el(r(table),1,16)
	mat app12cilc=el(r(table),5,16)
	mat app12cihc=el(r(table),6,16)
	
	mat app12estbas=el(r(table),1,17)
	mat app12cilbas=el(r(table),5,17)
	mat app12cihbas=el(r(table),6,17)
	
	mat app12estmax=el(r(table),1,18)
	mat app12cilmax=el(r(table),5,18)
	mat app12cihmax=el(r(table),6,18)
	
	mat app12estsimp=el(r(table),1,19)
	mat app12cilsimp=el(r(table),5,19)
	mat app12cihsimp=el(r(table),6,19)
	
	mat app12estcomb=el(r(table),1,20)
	mat app12cilcomb=el(r(table),5,20)
	mat app12cihcomb=el(r(table),6,20)
	
	mat app15estc=el(r(table),1,21)
	mat app15cilc=el(r(table),5,21)
	mat app15cihc=el(r(table),6,21)
	
	mat app15estbas=el(r(table),1,22)
	mat app15cilbas=el(r(table),5,22)
	mat app15cihbas=el(r(table),6,22)
	
	mat app15estmax=el(r(table),1,23)
	mat app15cilmax=el(r(table),5,23)
	mat app15cihmax=el(r(table),6,23)
	
	mat app15estsimp=el(r(table),1,24)
	mat app15cilsimp=el(r(table),5,24)
	mat app15cihsimp=el(r(table),6,24)
	
	mat app15estcomb=el(r(table),1,25)
	mat app15cilcomb=el(r(table),5,25)
	mat app15cihcomb=el(r(table),6,25)
	
	mat app18estc=el(r(table),1,26)
	mat app18cilc=el(r(table),5,26)
	mat app18cihc=el(r(table),6,26)
	
	mat app18estbas=el(r(table),1,27)
	mat app18cilbas=el(r(table),5,27)
	mat app18cihbas=el(r(table),6,27)
	
	mat app18estmax=el(r(table),1,28)
	mat app18cilmax=el(r(table),5,28)
	mat app18cihmax=el(r(table),6,28)
	
	mat app18estsimp=el(r(table),1,29)
	mat app18cilsimp=el(r(table),5,29)
	mat app18cihsimp=el(r(table),6,29)
	
	mat app18estcomb=el(r(table),1,30)
	mat app18cilcomb=el(r(table),5,30)
	mat app18cihcomb=el(r(table),6,30)
	
	mat app21estc=el(r(table),1,31)
	mat app21cilc=el(r(table),5,31)
	mat app21cihc=el(r(table),6,31)
	
	mat app21estbas=el(r(table),1,32)
	mat app21cilbas=el(r(table),5,32)
	mat app21cihbas=el(r(table),6,32)
	
	mat app21estmax=el(r(table),1,33)
	mat app21cilmax=el(r(table),5,33)
	mat app21cihmax=el(r(table),6,33)
	
	mat app21estsimp=el(r(table),1,34)
	mat app21cilsimp=el(r(table),5,34)
	mat app21cihsimp=el(r(table),6,34)
	
	mat app21estcomb=el(r(table),1,35)
	mat app21cilcomb=el(r(table),5,35)
	mat app21cihcomb=el(r(table),6,35)
	
	mat app24estc=el(r(table),1,36)
	mat app24cilc=el(r(table),5,36)
	mat app24cihc=el(r(table),6,36)
	
	mat app24estbas=el(r(table),1,37)
	mat app24cilbas=el(r(table),5,37)
	mat app24cihbas=el(r(table),6,37)
	
	mat app24estmax=el(r(table),1,38)
	mat app24cilmax=el(r(table),5,38)
	mat app24cihmax=el(r(table),6,38)
	
	mat app24estsimp=el(r(table),1,39)
	mat app24cilsimp=el(r(table),5,39)
	mat app24cihsimp=el(r(table),6,39)
	
	mat app24estcomb=el(r(table),1,40)
	mat app24cilcomb=el(r(table),5,40)
	mat app24cihcomb=el(r(table),6,40)
	
mean awarded3 awarded6 awarded9 awarded12 awarded15 awarded18 awarded21 awarded24 if treatment==1
	mat awd3estt=el(r(table),1,1)
	mat awd3cilt=el(r(table),5,1)
	mat awd3ciht=el(r(table),6,1)
	
	mat awd6estt=el(r(table),1,2)
	mat awd6cilt=el(r(table),5,2)
	mat awd6ciht=el(r(table),6,2)
	
	mat awd9estt=el(r(table),1,3)
	mat awd9cilt=el(r(table),5,3)
	mat awd9ciht=el(r(table),6,3)
	
	mat awd12estt=el(r(table),1,4)
	mat awd12cilt=el(r(table),5,4)
	mat awd12ciht=el(r(table),6,4)
	
	mat awd15estt=el(r(table),1,5)
	mat awd15cilt=el(r(table),5,5)
	mat awd15ciht=el(r(table),6,5)
	
	mat awd18estt=el(r(table),1,6)
	mat awd18cilt=el(r(table),5,6)
	mat awd18ciht=el(r(table),6,6)
	
	mat awd21estt=el(r(table),1,7)
	mat awd21cilt=el(r(table),5,7)
	mat awd21ciht=el(r(table),6,7)
		
	mat awd24estt=el(r(table),1,8)
	mat awd24cilt=el(r(table),5,8)
	mat awd24ciht=el(r(table),6,8)

mean awarded3 awarded6 awarded9 awarded12 awarded15 awarded18 awarded21 awarded24, over(treatment)
	mat awd3estc=el(r(table),1,1)
	mat awd3cilc=el(r(table),5,1)
	mat awd3cihc=el(r(table),6,1)
	
	mat awd3estbas=el(r(table),1,2)
	mat awd3cilbas=el(r(table),5,2)
	mat awd3cihbas=el(r(table),6,2)
	
	mat awd3estmax=el(r(table),1,3)
	mat awd3cilmax=el(r(table),5,3)
	mat awd3cihmax=el(r(table),6,3)
	
	mat awd3estsimp=el(r(table),1,4)
	mat awd3cilsimp=el(r(table),5,4)
	mat awd3cihsimp=el(r(table),6,4)
	
	mat awd3estcomb=el(r(table),1,5)
	mat awd3cilcomb=el(r(table),5,5)
	mat awd3cihcomb=el(r(table),6,5)
	
	mat awd6estc=el(r(table),1,6)
	mat awd6cilc=el(r(table),5,6)
	mat awd6cihc=el(r(table),6,6)
	
	mat awd6estbas=el(r(table),1,7)
	mat awd6cilbas=el(r(table),5,7)
	mat awd6cihbas=el(r(table),6,7)
	
	mat awd6estmax=el(r(table),1,8)
	mat awd6cilmax=el(r(table),5,8)
	mat awd6cihmax=el(r(table),6,8)
	
	mat awd6estsimp=el(r(table),1,9)
	mat awd6cilsimp=el(r(table),5,9)
	mat awd6cihsimp=el(r(table),6,9)
	
	mat awd6estcomb=el(r(table),1,10)
	mat awd6cilcomb=el(r(table),5,10)
	mat awd6cihcomb=el(r(table),6,10)
	
	mat awd9estc=el(r(table),1,11)
	mat awd9cilc=el(r(table),5,11)
	mat awd9cihc=el(r(table),6,11)
	
	mat awd9estbas=el(r(table),1,12)
	mat awd9cilbas=el(r(table),5,12)
	mat awd9cihbas=el(r(table),6,12)
	
	mat awd9estmax=el(r(table),1,13)
	mat awd9cilmax=el(r(table),5,13)
	mat awd9cihmax=el(r(table),6,13)
	
	mat awd9estsimp=el(r(table),1,14)
	mat awd9cilsimp=el(r(table),5,14)
	mat awd9cihsimp=el(r(table),6,14)
	
	mat awd9estcomb=el(r(table),1,15)
	mat awd9cilcomb=el(r(table),5,15)
	mat awd9cihcomb=el(r(table),6,15)
	
	mat awd12estc=el(r(table),1,16)
	mat awd12cilc=el(r(table),5,16)
	mat awd12cihc=el(r(table),6,16)
	
	mat awd12estbas=el(r(table),1,17)
	mat awd12cilbas=el(r(table),5,17)
	mat awd12cihbas=el(r(table),6,17)
	
	mat awd12estmax=el(r(table),1,18)
	mat awd12cilmax=el(r(table),5,18)
	mat awd12cihmax=el(r(table),6,18)
	
	mat awd12estsimp=el(r(table),1,19)
	mat awd12cilsimp=el(r(table),5,19)
	mat awd12cihsimp=el(r(table),6,19)
	
	mat awd12estcomb=el(r(table),1,20)
	mat awd12cilcomb=el(r(table),5,20)
	mat awd12cihcomb=el(r(table),6,20)
	
	mat awd15estc=el(r(table),1,21)
	mat awd15cilc=el(r(table),5,21)
	mat awd15cihc=el(r(table),6,21)
	
	mat awd15estbas=el(r(table),1,22)
	mat awd15cilbas=el(r(table),5,22)
	mat awd15cihbas=el(r(table),6,22)
	
	mat awd15estmax=el(r(table),1,23)
	mat awd15cilmax=el(r(table),5,23)
	mat awd15cihmax=el(r(table),6,23)
	
	mat awd15estsimp=el(r(table),1,24)
	mat awd15cilsimp=el(r(table),5,24)
	mat awd15cihsimp=el(r(table),6,24)
	
	mat awd15estcomb=el(r(table),1,25)
	mat awd15cilcomb=el(r(table),5,25)
	mat awd15cihcomb=el(r(table),6,25)
	
	mat awd18estc=el(r(table),1,26)
	mat awd18cilc=el(r(table),5,26)
	mat awd18cihc=el(r(table),6,26)
	
	mat awd18estbas=el(r(table),1,27)
	mat awd18cilbas=el(r(table),5,27)
	mat awd18cihbas=el(r(table),6,27)
	
	mat awd18estmax=el(r(table),1,28)
	mat awd18cilmax=el(r(table),5,28)
	mat awd18cihmax=el(r(table),6,28)
	
	mat awd18estsimp=el(r(table),1,29)
	mat awd18cilsimp=el(r(table),5,29)
	mat awd18cihsimp=el(r(table),6,29)
	
	mat awd18estcomb=el(r(table),1,30)
	mat awd18cilcomb=el(r(table),5,30)
	mat awd18cihcomb=el(r(table),6,30)
	
	mat awd21estc=el(r(table),1,31)
	mat awd21cilc=el(r(table),5,31)
	mat awd21cihc=el(r(table),6,31)
	
	mat awd21estbas=el(r(table),1,32)
	mat awd21cilbas=el(r(table),5,32)
	mat awd21cihbas=el(r(table),6,32)
	
	mat awd21estmax=el(r(table),1,33)
	mat awd21cilmax=el(r(table),5,33)
	mat awd21cihmax=el(r(table),6,33)
	
	mat awd21estsimp=el(r(table),1,34)
	mat awd21cilsimp=el(r(table),5,34)
	mat awd21cihsimp=el(r(table),6,34)
	
	mat awd21estcomb=el(r(table),1,35)
	mat awd21cilcomb=el(r(table),5,35)
	mat awd21cihcomb=el(r(table),6,35)
	
	mat awd24estc=el(r(table),1,36)
	mat awd24cilc=el(r(table),5,36)
	mat awd24cihc=el(r(table),6,36)
	
	mat awd24estbas=el(r(table),1,37)
	mat awd24cilbas=el(r(table),5,37)
	mat awd24cihbas=el(r(table),6,37)
	
	mat awd24estmax=el(r(table),1,38)
	mat awd24cilmax=el(r(table),5,38)
	mat awd24cihmax=el(r(table),6,38)
	
	mat awd24estsimp=el(r(table),1,39)
	mat awd24cilsimp=el(r(table),5,39)
	mat awd24cihsimp=el(r(table),6,39)
	
	mat awd24estcomb=el(r(table),1,40)
	mat awd24cilcomb=el(r(table),5,40)
	mat awd24cihcomb=el(r(table),6,40)
	
forvalues x = 3(3)24 {													
	mat est`x'app=(app`x'estc, app`x'estt,  app`x'estbas, app`x'estmax, app`x'estsimp, app`x'estcomb)
	mat ci_low`x'app=(app`x'cilc, app`x'cilt, app`x'cilbas, app`x'cilmax, app`x'cilsimp, app`x'cilcomb)
	mat ci_hi`x'app=(app`x'cihc, app`x'ciht, app`x'cihbas, app`x'cihmax, app`x'cihsimp, app`x'cihcomb)

	mat est`x'awd=(awd`x'estc, awd`x'estt,  awd`x'estbas, awd`x'estmax, awd`x'estsimp, awd`x'estcomb)
	mat ci_low`x'awd=(awd`x'cilc, awd`x'cilt, awd`x'cilbas, awd`x'cilmax, awd`x'cilsimp, awd`x'cilcomb)
	mat ci_hi`x'awd=(awd`x'cihc, awd`x'ciht, awd`x'cihbas, awd`x'cihmax, awd`x'cihsimp, awd`x'cihcomb)

}

	mat est_app_t=(app3estt, app6estt, app9estt, app12estt, app15estt, app18estt, app21estt, app24estt)
	mat est_app_c=(app3estc, app6estc, app9estc, app12estc, app15estc, app18estc, app21estc, app24estc)

	mat est_awd_t=(awd3estt, awd6estt, awd9estt, awd12estt, awd15estt, awd18estt, awd21estt, awd24estt)
	mat est_awd_c=(awd3estc, awd6estc, awd9estc, awd12estc, awd15estc, awd18estc, awd21estc, awd24estc)

	
			mat coef_fig3= (est_app_t \ est_app_c \ est_awd_t \ est_awd_c)
			
			mat rownames coef_fig3= AppT AppC AwdT AwdC 
			mat colnames coef_fig3= 3 6 9 12 15 18 21 24
			mat list coef_fig3
			mat coef_fig3p=coef_fig3'

matsave coef_fig3p, replace saving

	capture mat drop raw1
	foreach x of varlist applied3-applied24 awarded3-awarded24 {
		prtest `x', by(anyletter)
		mat raw1=(nullmat(raw1)\r(N1),r(P1),r(se1),r(N2),r(P2),r(se2),r(p),r(P_diff))
	}
	mat list raw1
	
graph bar (mean) applied3 (mean) applied6 (mean) applied9 (mean) applied12 (mean) applied15 (mean) applied18 (mean) applied21 (mean) applied24 if anyletter==1, over(anyletter)
graph bar (mean) awarded3 (mean) awarded6 (mean) awarded9 (mean) awarded12 (mean) awarded15 (mean) awarded18 (mean) awarded21 (mean) awarded24 if anyletter==1, over(anyletter)


mean applied3 applied6 applied9 applied12 applied15 applied18 applied21 applied24, over(treatment)
egen mean3=mean(applied3), by(treatment)
egen mean6=mean(applied3), by(treatment)
egen mean9=mean(applied3), by(treatment)
egen mean12=mean(applied3), by(treatment)
egen mean15=mean(applied3), by(treatment)
egen mean18=mean(applied3), by(treatment)
egen mean21=mean(applied3), by(treatment)
egen mean24=mean(applied3), by(treatment)

twoway connected mean3-mean24 if treatment==0 ///
|| connected mean3-mean24 if inlist(treatment,1,2,3,4) ///
|| connected mean3-mean24 if treatment==1 ///
|| connected mean3-mean24 if treatment==2 ///
|| connected mean3-mean24 if treatment==3 ///
|| connected mean3-mean24 if treatment==4 

	




/*Appendix Table A1*/ /*Summary Statistics*/

capture mat drop sum
	/*Total*/
	estpost tabstat age age_group_* male prior potentialssi quint_* state209 statessi medicaid wepgpo bica bentype_* ///
		anyearn1-anyearn5 anyearn_last2 anyearn_last5 earn_inelig inelig /*earnben_inelig_* */ zip_nw former_ssi before_fra, ///
		listwise statistics(mean sd) columns(statistics)
		mat m=e(mean)
		mat m=m'
		mat sd=e(sd)
		mat sd=sd'
		mat sum=(nullmat(sum),m,sd)
	/*Any Letter*/
	estpost tabstat age age_group_* male prior potentialssi quint_* state209 statessi medicaid wepgpo bica bentype_* ///
		anyearn1-anyearn5 anyearn_last2 anyearn_last5 earn_inelig inelig /*earnben_inelig_* */ zip_nw former_ssi before_fra if anyletter==1, ///
		listwise statistics(mean sd) columns(statistics)	
		mat m=e(mean)
		mat m=m'
		mat sd=e(sd)
		mat sd=sd'
		mat sum=(nullmat(sum),m,sd)
	/*Study Group*/
	forvalues i=0(1)4 {
		estpost tabstat age age_group_* male prior potentialssi quint_* state209 statessi medicaid wepgpo bica bentype_* ///
		anyearn1-anyearn5 anyearn_last2 anyearn_last5 earn_inelig inelig /*earnben_inelig_* */ zip_nw former_ssi before_fra if treatment==`i', ///
			listwise statistics(mean sd) columns(statistics)	
		mat m=e(mean)
		mat m=m'
		mat sd=e(sd)
		mat sd=sd'
		mat sum=(nullmat(sum),m,sd)	
	}	
mat list sum
			

/*Appendix Tables 2 and 3*/

capture erase appendix2_3.xml
capture erase appendix2_3.txt

	foreach y of varlist applied24 awarded24 avessi24 anyssi24 totssi24 denycond24 {
	
		/*Statements--Letter Elements*/
		reg `y' ib0.treatment, cluster(state)
		outreg2 using table2_3, ctitle(`y'-statement) bdec(4) sdec(4) cdec(4) excel wide
		
	}	


/*Appendix Tables A4-A7*/

capture erase appendix4_7.xml
capture erase appendix4_7.txt

	foreach y of varlist applied24 awarded24 avessi24 anyssi24 totssi24 denycond24 {
	    /*Treatment Group--Letter Type*/
		reg `y' ib0.treatment age i.male potentialssi i.prior i.state, cluster(state)
		outreg2 using appendix4_7, ctitle(`y'-type) bdec(4) sdec(4) cdec(4) excel wide
	
		/*Statements--Letter Elements*/
		reg `y' anyletter i.maxbenefit##i.simplifying age potentialssi i.male i.prior i.state, cluster(state)
		outreg2 using appendix4_7, ctitle(`y'-statement) bdec(4) sdec(4) cdec(4) excel wide

	}
	
	
	
/*Appendix Tables A8-A15*/

capture erase appendix8_15.xml
capture erase appendix8_15.txt


	foreach y of varlist applied24 awarded24 avessi24 {
		
		/*1634 State--Table A7*/
		reg `y' ib0.anyletter##i.medicaid /*, cluster(state)*/
		outreg2 using appendix8_15, ctitle(`y'-Medicaid) bdec(4) sdec(4) cdec(4) excel wide
		
		/*WEP/GPO--Table A8*/
		reg `y' ib0.anyletter##i.wepgpo , cluster(state)
		outreg2 using appendix8_15, ctitle(`y'-WEPGPO) bdec(4) sdec(4) cdec(4) excel wide

		/*Beneficiary Type--Table A10*/
		reg `y' ib0.anyletter##ib1.bentype2, cluster(state)
		outreg2 using appendix8_15, ctitle(`y'-Beneficiary Type) bdec(4) sdec(4) cdec(4) excel wide
	
		/*Earnings--Table A11*/
		reg `y' ib0.anyletter##ib1.earn_inelig, cluster(state)
		outreg2 using appendix8_15, ctitle(`y'-Earnings) bdec(4) sdec(4) cdec(4) excel wide

		/*Race--Table A12*/
		reg `y' ib0.anyletter##c.zip_nw, cluster(state)
		outreg2 using appendix8_15, ctitle(`y'-Race) bdec(4) sdec(4) cdec(4) excel wide

		/*Prior SSI--Table A13*/
		reg `y' ib0.anyletter##ib0.former_ssi, cluster(state)
		outreg2 using appendix8_15, ctitle(`y'-Prior SSI) bdec(4) sdec(4) cdec(4) excel wide
	
		/*State--Table A14*/
		reg `y' ib0.anyletter##i.state, cluster(state)
		outreg2 using appendix8_15, ctitle(`y'-State) bdec(4) sdec(4) cdec(4) excel wide
	
		/*Claim Age--Table A15*/
		reg `y' ib0.anyletter##ib0.before_fra, cluster(state)
		outreg2 using appendix8_15, ctitle(`y'-Claim Age) bdec(4) sdec(4) cdec(4) excel wide

	
	}

	

sum applied24 awarded24 avessi24 numssimiss24 numssi24 ///
		anyssi24 totssi24 totssimiss24 denycond24 ///
		if treatment==0, sep(0)

		
log close

tab  denied24a treatment if denied24a_6~=1 & denied24a_5~=1 & treatment==0, col
tab  denied24a if denied24a_6~=1 & denied24a_5~=1 & treatment~=0



use outcomes06062022, clear
compress

label define treatment 0 "Control" 1 "Basic" 2 "Maximum" 3 "Simplify" 4 "Combined", replace
label values treatment treatment
label define age_group 0 "65" 1 "66 to 70" 2 "71 to 75" 3 "76 to 80", replace
label values age_group age_group

gen former_ssi=(prior_ssi_status==2)
drop if treatment==.

export excel can boan bic using forOARO_Tonly.xlsx if treatment~=0


	
	
bysort anyletter: sum age i.age_group potentialssi i.potentialquint zip_nw male prior wepgpo bica anyearn1-anyearn5 anyearn_last2 anyearn_last5 earn_inelig inelig former_ssi before_fra i.bentype2 i.state_group /*i.state*/ if applied24==1, sep(0)

